<?php
/**
 * config.php
 * Easypay聚合支付系统
 * =========================================================
 * Copy right 2015-2025 Easypay, 保留所有权利。
 * ----------------------------------------------
 * 官方网址: http://www.0533hf.com
 *
 * 请尊重开发人员劳动成果，严禁使用本系统转卖、销售或二次开发后转卖、销售等商业行为。
 * 任何企业和个人不允许对程序代码以任何形式任何目的再发布。
 * =========================================================
 * @author : 366131726@qq.com
 * @date : 2019-05-14
 */

error_reporting(E_ALL & ~E_NOTICE);
date_default_timezone_set('Asia/Shanghai');
header("Content-type: text/html; charset=utf-8");

$gateway = 'http://api.0533hf.com';      //网关地址
$merId = '2019051'; //商户号
$md5Key = 'oqEusKNCynLAQIiYmrXJTHFfaODzkMpP';
//平台公钥
$publicKey = 'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAu/d6Tqx7e17Cgzc7HDhwKB5IJmqTtRbnQX8kScvWRml1LIe2+TBhU9NRAyjh08iF/w3gIznXv3oogMfABsGGGr0sIwXPHS/uAt8zr5k6YKE5GzDFYfwrVI8865pJBAwmkjVPlvxYDueBv6pPj/yPUhJWkYepFMinIL0IBipTbIfNynR/ynHlezWvSkXkhPvW2rwhbKW+wUewl1KXsEC21/PaDuWYjOTIZ0XifRtKS/KU4MWlf8Oj/YezPvkmz5u5i7wfzOLK1QO7LKbGJf/VweREE+FeUpxCwvO42CpbJOzIMAvna467GuxrM2OyPvKApBHBWjcTOZ+RZ+5R7bHe2QIDAQAB';
//商户私钥
$privateKey = 'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCHwUldbo6xeG4mcCbbPNLAiZGBQHnXjbDeBmxI9hguldCSyO782+HXeO6e2zifLRjblMwcr5DFpeR6SMXfw6P+K/xlsX5RiBdohFODXS5oGHL2AOCVRcY5onKc83+q16BK3rgCpWj5hcEG3C1a7hX7tcQ9zDzvfk4LEsNnRG7ton8Qudl/TYyHZRfNJAS31UzHYaNFezTemPGSl0hwenTdbcp+Uku9webS3q+1JjDu6wxMBx6JD8yBKbWQ9guPePGteVI8lPC0RPyFQugGvleSyqU/OSQQIL2zihNAcoPucP9jQRLCV7ahSsxw7FKDwaP7IWwCHtM18PIxRWpmCWvBAgMBAAECggEAL9Gg8x1XfCIMwtNsjHtfTVzn+RxqDsilTX/7srOlDvvMrXfD3yPg6JJ7k09rIX60K9y9DTm2iDiIQ57QvKJgaM67qGKeOT/z5uf9tt8i0p4SGJ90fIBIc9LKBokrJlWv68+KB7yWPpajyLPT8hy9d52uU4pWyJG4EeR5Gi4b2O6HbhZuvSKcJHRW5yrZYAgW52GG7YIn8HOCNCZULe27PV4VKqlkjKFeYmjnkl9Q5L0nmY4yxROX8a8CbOt09bn4sML6vBTENk4I2dJgHvPSgmgCup7Kfzj2QumzRqP8E2qcmLMHm+q1HUzJwj1lrqu5XR60V3R1gnaarP4madYL8QKBgQDi3KF7qPCdmfTWTJHQHMfAs9/FtQCGWLTASAPIvKE/aTzMEw3GOfsde2nF4AUfTNQmTTgrjt6mM2jb1+Iqfc+okfRV/c0PFpErnkglBvL37PIDifw0Uesr1306Mnp182j0TsKF/0hKaKk9KzBVXqu29+v+tC7nnuQVO5r2WAZLvQKBgQCZMQC0HjraM1omj3HfrEIzWvlZ1Ra3aPcSFAsd+ru1gK+Ev5XtR0uo/wPeJCSMSwDh0V22DH8kOhec9vJvSgebmtorQ4svfED+fhqk/6PKTbwY1b8dQQPtkhssYH5oDkZr2rBtQeXb76+NzBTQ8+CS98kqp7KKYXnQwS5vfGy+VQKBgQC/ygBnF8rboiV/6lm3VC13d1ntvfjEm0er6vXwBbBYeHKioFUbyTbHlOc2Fw6diIkuHEgpYu5OGdZDTX5xp80f2Mx0yk1KvSxbcMPTMc3E1bdAUK472Sl09gdzZOtsvixzpgYD3G7UISk6gkGpWpDW7T/BI7knrYdrf+mg64ffDQKBgD9fFSJtyvzO94EyH/JeiThDbxlpXC9dXa/92Kd7PMGVzYYF11jEAJmVfR0dKH1c3a2M9c5Elyf+XBxTz/CX2FPXmF8DXwWyyhQ9SHpvQmuDAsfnTFsmtSBHK7SM6l3TYfBmFEvuUc9M9PucrBPQf1ts46wgmWxDbKgd8j6uYzHNAoGAQ7Tlxy+bo6oaTiJEkdnJGXrHvIz8h86TqyPdn+4YybR2mTPoTAcj8C1Vc5L0w4eYrkwVunt18N0ZWdqgqMGVk+Yr0fRdD66jh9tN10vbNs+yP7j4hmGZBYffTKy81AYUq1L4bd8sRmyZbSRlWkl0FSQrRD06u35Fa/IouI5/QCY=';

require 'Rsa.php';
require 'Http.php';
require 'Random.php';

/**
 * 签名算法
 * @param $data         请求数据
 * @param $md5Key       md5秘钥
 * @param $privateKey   商户私钥
 */
function sign($data,$md5Key,$privateKey){
    ksort($data);
    reset($data);
    $arg = '';
    foreach ($data as $key => $val) {
        //空值不参与签名
        if ($val == '' || $key == 'sign') {
            continue;
        }
        $arg .= ($key . '=' . $val . '&');
    }
    $arg = $arg . 'key=' . $md5Key;

    //签名数据转换为大写
    $sig_data = strtoupper(md5($arg));
    //使用RSA签名
    $rsa = new Rsa('', $privateKey);
    //私钥签名
    return $rsa->sign($sig_data);
}

/**
 * 验签
 * @param $data         返回数据
 * @param $md5Key       md5秘钥
 * @param $pubKey       平台公钥
 */
function verify($data,$md5Key,$pubKey){
    //验签
    ksort($data);
    reset($data);
    $arg = '';
    foreach ($data as $key => $val) {
        //空值不参与签名
        if ($val == '' || $key == 'sign') {
            continue;
        }
        $arg .= ($key . '=' . $val . '&');
    }
    $arg = $arg . 'key=' . $md5Key;
    $signData = strtoupper(md5($arg));
    $rsa = new Rsa($pubKey, '');
    if ($rsa->verify($signData, $data['sign']) == 1) {
        return true;
    }
    return false;
}


